/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
public class Base64Benchmark {
    private byte[] TEST_BYTES;

    @Setup
    public void setup() {
        this.TEST_BYTES = new byte[16];
        new SecureRandom().nextBytes(this.TEST_BYTES);
    }

    @Benchmark
    public String jdkBase64Encode() {
        return java.util.Base64.getEncoder().encodeToString(this.TEST_BYTES);
    }

    @Benchmark
    public String commonsBase64Encode() {
        return Base64.encodeBase64String((byte[])this.TEST_BYTES);
    }

    @Benchmark
    public String hutoolBase64Encode() {
        return cn.hutool.core.codec.Base64.encode((byte[])this.TEST_BYTES);
    }

    @Benchmark
    public String guavaBase64Encode() {
        return BaseEncoding.base64().encode(this.TEST_BYTES);
    }

    @Benchmark
    public byte[] jdkBase64Decode() {
        String encoded = java.util.Base64.getEncoder().encodeToString(this.TEST_BYTES);
        return java.util.Base64.getDecoder().decode(encoded);
    }

    @Benchmark
    public byte[] commonsBase64Decode() {
        String encoded = Base64.encodeBase64String((byte[])this.TEST_BYTES);
        return Base64.decodeBase64((String)encoded);
    }

    @Benchmark
    public byte[] hutoolBase64Decode() {
        String encoded = cn.hutool.core.codec.Base64.encode((byte[])this.TEST_BYTES);
        return cn.hutool.core.codec.Base64.decode((CharSequence)encoded);
    }

    @Benchmark
    public byte[] guavaBase64Decode() {
        String encoded = BaseEncoding.base64().encode(this.TEST_BYTES);
        return BaseEncoding.base64().decode((CharSequence)encoded);
    }
}

