/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import com.google.common.io.BaseEncoding;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
public class Base64DecodeBenchmark {
    private byte[] TEST_BYTES;
    private String JDK_ENCODED;
    private String COMMONS_ENCODED;
    private String HUTOOL_ENCODED;
    private String GUAVA_ENCODED;
    private String NETTY_ENCODED;

    @Setup
    public void setup() {
        this.TEST_BYTES = new byte[16];
        new SecureRandom().nextBytes(this.TEST_BYTES);
        this.JDK_ENCODED = java.util.Base64.getEncoder().encodeToString(this.TEST_BYTES);
        this.COMMONS_ENCODED = Base64.encodeBase64String((byte[])this.TEST_BYTES);
        this.HUTOOL_ENCODED = cn.hutool.core.codec.Base64.encode((byte[])this.TEST_BYTES);
        this.GUAVA_ENCODED = BaseEncoding.base64().encode(this.TEST_BYTES);
    }

    @Benchmark
    public byte[] jdkBase64Decode() {
        return java.util.Base64.getDecoder().decode(this.JDK_ENCODED);
    }

    @Benchmark
    public byte[] commonsBase64Decode() {
        return Base64.decodeBase64((String)this.COMMONS_ENCODED);
    }

    @Benchmark
    public byte[] hutoolBase64Decode() {
        return cn.hutool.core.codec.Base64.decode((CharSequence)this.HUTOOL_ENCODED);
    }

    @Benchmark
    public byte[] guavaBase64Decode() {
        return BaseEncoding.base64().decode((CharSequence)this.GUAVA_ENCODED);
    }

    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder().include(Base64DecodeBenchmark.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

