/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import uno.xifan.id.generator.distributed.atomiclong.AtomicLongIdGenerator;
import uno.xifan.id.generator.distributed.cosid.CosIdGenerator;
import uno.xifan.id.generator.distributed.dtsid.DtsIdGenerator;
import uno.xifan.id.generator.distributed.mist.MistIdGenerator;
import uno.xifan.id.generator.distributed.rid.RedissonIdGenerator;
import uno.xifan.id.generator.distributed.segmentid.concurrent.SegmentChainIdGenerator;
import uno.xifan.id.generator.distributed.snowflake.SnowflakeIdGenerator;
import uno.xifan.id.generator.distributed.ttsid.TtsIdPlusGenerator;
import uno.xifan.id.generator.distributed.wxseq.WxSeqGenerator;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Threads(value=24)
@Warmup(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=10, timeUnit=TimeUnit.SECONDS)
public class DistributedIdBenchmark {
    private RedissonClient redisson;
    private AtomicLongIdGenerator atomicLongIdGenerator;
    private CosIdGenerator cosIdGenerator;
    private DtsIdGenerator dtsIdGenerator;
    private MistIdGenerator mistIdGenerator;
    private RedissonIdGenerator redissonIdGenerator;
    private SnowflakeIdGenerator snowflakeIdGenerator;
    private TtsIdPlusGenerator ttsIdPlusGenerator;
    private WxSeqGenerator wxSeqGenerator;
    private SegmentChainIdGenerator segmentChainIdGenerator;

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(DistributedIdBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @Setup
    public void setup() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379").setConnectionMinimumIdleSize(24).setConnectionPoolSize(24);
        this.redisson = Redisson.create((Config)config);
        this.atomicLongIdGenerator = new AtomicLongIdGenerator(this.redisson);
        this.cosIdGenerator = new CosIdGenerator(this.redisson, 44, 20, 16, 0L);
        this.dtsIdGenerator = new DtsIdGenerator(this.redisson);
        this.mistIdGenerator = new MistIdGenerator(this.redisson);
        this.redissonIdGenerator = new RedissonIdGenerator(this.redisson, "rid", 0L, 1000L);
        this.snowflakeIdGenerator = new SnowflakeIdGenerator(this.redisson, 0L, 41, 10, 12);
        this.ttsIdPlusGenerator = new TtsIdPlusGenerator(this.redisson);
        this.wxSeqGenerator = new WxSeqGenerator(this.redisson);
        this.segmentChainIdGenerator = new SegmentChainIdGenerator(this.redisson);
    }

    @TearDown
    public void tearDown() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }

    public void testAtomicLongId(Blackhole bh) {
        bh.consume((Object)this.atomicLongIdGenerator.generate());
    }

    public void testCosId(Blackhole bh) {
        bh.consume((Object)this.cosIdGenerator.generate());
    }

    public void testDtsId(Blackhole bh) {
        bh.consume((Object)this.dtsIdGenerator.generate());
    }

    @Benchmark
    public void testMistId(Blackhole bh) {
        bh.consume(this.mistIdGenerator.generate().toLong());
    }

    public void testRedissonId(Blackhole bh) {
        bh.consume((Object)this.redissonIdGenerator.generate());
    }

    public void testSnowflakeId(Blackhole bh) {
        bh.consume((Object)this.snowflakeIdGenerator.generate());
    }

    public void testTtsIdPlus(Blackhole bh) {
        bh.consume((Object)this.ttsIdPlusGenerator.generate());
    }

    public void testWxSeq(Blackhole bh) {
        bh.consume((Object)this.wxSeqGenerator.generate());
    }

    @Benchmark
    public void testSegmentChain(Blackhole bh) {
        bh.consume((Object)this.segmentChainIdGenerator.generate());
    }
}

