/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import uno.xifan.id.util.IdUtil;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=2, warmups=1)
@Threads(value=16)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=2, timeUnit=TimeUnit.SECONDS)
public class IdGeneratorBenchmark {
    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(IdGeneratorBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @Benchmark
    public void testCombGuid(Blackhole blackhole) {
        String id = IdUtil.combguid();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testCuid1(Blackhole blackhole) {
        String id = IdUtil.cuid1();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testCuid2(Blackhole blackhole) {
        String id = IdUtil.cuid2();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testElasticflake(Blackhole blackhole) {
        String id = IdUtil.elasticflake();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testEntropyId(Blackhole blackhole) {
        long id = IdUtil.entropy();
        blackhole.consume(id);
    }

    @Benchmark
    public void testJavaScriptSafetyId(Blackhole blackhole) {
        long id = IdUtil.javaScriptSafetyId();
        blackhole.consume(id);
    }

    @Benchmark
    public void testKsuid(Blackhole blackhole) {
        String id = IdUtil.ksuid();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testLexicalUuid(Blackhole blackhole) {
        String id = IdUtil.lexicalUuid();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testNanoId(Blackhole blackhole) {
        String id = IdUtil.nanoId();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testObjectId(Blackhole blackhole) {
        String id = IdUtil.objectId();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testOrderedUuid(Blackhole blackhole) {
        String id = IdUtil.orderedUuid();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testPushId(Blackhole blackhole) {
        String id = IdUtil.pushId();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testSid(Blackhole blackhole) {
        String id = IdUtil.sid();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testBusinessId(Blackhole blackhole) {
        long id = IdUtil.businessId();
        blackhole.consume(id);
    }

    @Benchmark
    public void testUlid(Blackhole blackhole) {
        String id = IdUtil.ulid();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testUuid1(Blackhole blackhole) {
        String id = IdUtil.uuid1();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testUuid2(Blackhole blackhole) {
        String id = IdUtil.uuid2();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testUuid4(Blackhole blackhole) {
        String id = IdUtil.uuid4();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testUuid6(Blackhole blackhole) {
        String id = IdUtil.uuid6();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testUuid7(Blackhole blackhole) {
        String id = IdUtil.uuid7();
        blackhole.consume((Object)id);
    }

    @Benchmark
    public void testXid(Blackhole blackhole) {
        String id = IdUtil.xid();
        blackhole.consume((Object)id);
    }
}

