/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import uno.xifan.id.generator.util.Clock;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Threads(value=16)
@Fork(value=0)
@Warmup(iterations=1, time=1)
@Measurement(iterations=1, time=1)
public class TimeBenchmark {
    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(TimeBenchmark.class.getSimpleName()).build();
        new Runner(opt).run();
    }

    @Benchmark
    public void now(Blackhole bh) {
        bh.consume((Object)Instant.now());
    }

    @Benchmark
    public void currentTimeMillis(Blackhole bh) {
        bh.consume(System.currentTimeMillis());
    }

    @Benchmark
    public void customTime(Blackhole bh) {
        bh.consume(Clock.currentTimeNanos());
    }

    @Benchmark
    public void nanoTime(Blackhole bh) {
        bh.consume(System.nanoTime());
    }
}

