/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator;

import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import uno.xifan.id.generator.distributed.ttsid.TtsIdGenerator;
import uno.xifan.id.generator.distributed.ttsid.TtsIdGeneratorConfig;
import uno.xifan.id.generator.distributed.ttsid.TtsIdMiniGenerator;
import uno.xifan.id.generator.distributed.ttsid.TtsIdMiniGeneratorConfig;
import uno.xifan.id.generator.distributed.ttsid.TtsIdPlusGenerator;
import uno.xifan.id.generator.distributed.ttsid.TtsIdProGenerator;
import uno.xifan.id.generator.distributed.ttsid.TtsIdProMaxGenerator;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Threads(value=1024)
@Warmup(iterations=3, time=10)
@Measurement(iterations=5, time=10)
public class TtsIdBenchmark {
    private RedissonClient redisson;
    private TtsIdMiniGenerator ttsIdMiniGenerator;
    private TtsIdGenerator ttsIdGenerator;
    private TtsIdPlusGenerator ttsIdPlusGenerator;
    private TtsIdProGenerator ttsIdProGenerator;
    private TtsIdProMaxGenerator ttsIdProMaxGenerator;

    @Setup
    public void setup() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379").setConnectionMinimumIdleSize(1024).setConnectionPoolSize(1024);
        this.redisson = Redisson.create((Config)config);
        this.ttsIdMiniGenerator = new TtsIdMiniGenerator(this.redisson, new TtsIdMiniGeneratorConfig());
        this.ttsIdGenerator = new TtsIdGenerator(this.redisson, new TtsIdGeneratorConfig());
        this.ttsIdPlusGenerator = new TtsIdPlusGenerator(this.redisson);
        this.ttsIdProGenerator = new TtsIdProGenerator(this.redisson);
        this.ttsIdProMaxGenerator = new TtsIdProMaxGenerator(this.redisson);
    }

    @TearDown
    public void tearDown() {
        if (this.redisson != null) {
            this.redisson.shutdown();
        }
    }

    @Benchmark
    public void testTtsIdMni(Blackhole bh) {
        bh.consume(this.ttsIdMiniGenerator.generate().toLong());
    }

    @Benchmark
    public void testTtsId(Blackhole bh) {
        bh.consume(this.ttsIdGenerator.generate().toLong());
    }

    @Benchmark
    public void testTtsIdPlus(Blackhole bh) {
        bh.consume((Object)this.ttsIdPlusGenerator.generate().toBase32());
    }

    @Benchmark
    public void testTtsIdPro(Blackhole bh) {
        bh.consume((Object)this.ttsIdProGenerator.generate().toBase16());
    }

    @Benchmark
    public void testTtsIdProMax(Blackhole bh) {
        bh.consume((Object)this.ttsIdProMaxGenerator.generate().toBase16());
    }
}

