/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.base;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class Base62 {
    private static final int STANDARD_BASE = 256;
    private static final int TARGET_BASE = 62;
    private static final byte[] ENCODE_MAP;
    private static final byte[] DECODE_MAP;

    public static String encode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        int estimatedLength = Base62.estimateOutputLength(bytes.length, 256, 62);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = bytes;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte b : source) {
                int accumulator = (b & 0xFF) + remainder * 256;
                int digit = (accumulator - accumulator % 62) / 62;
                remainder = accumulator % 62;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < bytes.length - 1 && bytes[i] == 0; ++i) {
            out.write(0);
        }
        byte[] indices = ArrayUtil.reverse(out.toByteArray());
        byte[] encoded = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            encoded[i] = ENCODE_MAP[indices[i]];
        }
        return new String(encoded);
    }

    public static byte[] decode(String str) {
        if (str == null || str.isEmpty()) {
            return new byte[0];
        }
        byte[] indices = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0080' || DECODE_MAP[c] == -1) {
                throw new IllegalArgumentException("Invalid Base62 character: " + c);
            }
            indices[i] = DECODE_MAP[c];
        }
        return Base62.convert(indices, 62, 256);
    }

    private static int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
    }

    private static byte[] convert(byte[] source, int sourceBase, int targetBase) {
        int estimatedLength = Base62.estimateOutputLength(source.length, sourceBase, targetBase);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] message = source;
        while (message.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(message.length);
            int remainder = 0;
            for (byte b : message) {
                int accumulator = (b & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            message = quotient.toByteArray();
        }
        for (int i = 0; i < source.length - 1 && source[i] == 0; ++i) {
            out.write(0);
        }
        return ArrayUtil.reverse(out.toByteArray());
    }

    static {
        int i;
        ENCODE_MAP = new byte[62];
        DECODE_MAP = new byte[128];
        int index = 0;
        for (i = 0; i < 10; ++i) {
            Base62.ENCODE_MAP[index] = (byte)(48 + i);
            ++index;
        }
        for (i = 0; i < 26; ++i) {
            Base62.ENCODE_MAP[index] = (byte)(65 + i);
            ++index;
        }
        for (i = 0; i < 26; ++i) {
            Base62.ENCODE_MAP[index] = (byte)(97 + i);
            ++index;
        }
        Arrays.fill(DECODE_MAP, (byte)-1);
        for (i = 0; i < ENCODE_MAP.length; ++i) {
            Base62.DECODE_MAP[Base62.ENCODE_MAP[i]] = (byte)i;
        }
    }

    private static class ArrayUtil {
        private ArrayUtil() {
        }

        public static byte[] reverse(byte[] array) {
            if (array == null) {
                return null;
            }
            int i = 0;
            for (int j = array.length - 1; j > i; --j, ++i) {
                byte tmp = array[j];
                array[j] = array[i];
                array[i] = tmp;
            }
            return array;
        }
    }
}

