/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.base;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import uno.xifan.id.base.Base16;
import uno.xifan.id.base.Base32;
import uno.xifan.id.base.Base36;
import uno.xifan.id.base.Base62;
import uno.xifan.id.base.Base64;

public interface Id {
    public byte[] toBytes();

    public long toLong();

    public String toString();

    default public byte[] long2bytes(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    default public byte[] longToBytes(long value) {
        return ByteBuffer.allocate(8).putLong(value).array();
    }

    default public String toBase64() {
        return Base64.encode(this.toBytes());
    }

    default public String toBase62() {
        return Base62.encode(this.toBytes());
    }

    default public String toBase36() {
        return Base36.encode(this.toBytes());
    }

    default public String toBase32() {
        return Base32.encode(this.toBytes());
    }

    default public String toBase16() {
        return Base16.encode(this.toBytes());
    }

    default public String toBase10() {
        return new BigInteger(this.toBase16(), 16).toString();
    }
}

