/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.broid.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.broid.BroIdGenerator;
import uno.xifan.id.generator.broid.BroIdLayout;
import uno.xifan.id.generator.broid.BroIdPart;
import uno.xifan.id.generator.broid.impl.UUIDv8BroId;
import uno.xifan.id.generator.broid.part.CounterBroIdPart;
import uno.xifan.id.generator.broid.part.RandomBroIdPart;
import uno.xifan.id.generator.broid.part.SpatiallyBroIdPart;
import uno.xifan.id.generator.broid.part.TimestampBroIdPart;
import uno.xifan.id.generator.broid.part.VariantBroIdPart;
import uno.xifan.id.generator.broid.part.VersionBroIdPart;

public class UUIDv8BroIdGenerator
extends BroIdGenerator<UUIDv8BroId>
implements IdGenerator {
    private static final AtomicLong counter = new AtomicLong();
    private static final long EPOCH = 1645557742L;
    private static final Random random = ThreadLocalRandom.current();
    private static final UUIDv8BroIdGenerator instance = UUIDv8BroIdGenerator.getInstance();

    public UUIDv8BroIdGenerator() {
        super(instance.getLayout(), instance.getConstructor());
    }

    public UUIDv8BroIdGenerator(BroIdLayout layout, Function<List<Boolean>, UUIDv8BroId> constructor) {
        super(layout, constructor);
    }

    public static UUIDv8BroIdGenerator getInstance() {
        ArrayList<BroIdPart> parts = new ArrayList<BroIdPart>();
        parts.add(new TimestampBroIdPart(TimeUnit.MILLISECONDS, 1645557742L, 48));
        parts.add(new VersionBroIdPart(8));
        parts.add(new CounterBroIdPart(counter, 12));
        parts.add(new VariantBroIdPart());
        parts.add(new SpatiallyBroIdPart(random.nextLong(), 14));
        parts.add(new RandomBroIdPart(random, 48));
        BroIdLayout layout = new BroIdLayout(parts);
        return new UUIDv8BroIdGenerator(layout, UUIDv8BroId::new);
    }

    @Override
    public String generate() {
        return ((UUIDv8BroId)this.next()).toUUID().toString();
    }

    @Override
    public IdType idType() {
        return IdType.BroId;
    }
}

