/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.objectid;

public final class Assertions {
    public static <T> T notNull(String name, T value) {
        if (value == null) {
            throw new IllegalArgumentException(name + " can not be null");
        }
        return value;
    }

    public static void isTrue(String name, boolean condition) {
        if (!condition) {
            throw new IllegalStateException("state should be: " + name);
        }
    }

    public static void isTrueArgument(String name, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("state should be: " + name);
        }
    }

    public static <T> T isTrueArgument(String name, T value, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("state should be: " + name);
        }
        return value;
    }

    public static AssertionError fail() throws AssertionError {
        throw new AssertionError();
    }

    public static AssertionError fail(String msg) throws AssertionError {
        throw new AssertionError((Object)Assertions.assertNotNull(msg));
    }

    public static <T> T assertNotNull(T value) throws AssertionError {
        if (value == null) {
            throw new AssertionError();
        }
        return value;
    }

    public static void assertTrue(String name, boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)("state should be: " + Assertions.assertNotNull(name)));
        }
    }

    public static <T> T convertToType(Class<T> clazz, Object value, String errorMessage) {
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(errorMessage);
        }
        return (T)value;
    }

    private Assertions() {
    }
}

