/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.shardingid;

import java.util.concurrent.atomic.AtomicInteger;

public class InstagramIdGenerator {
    private static final long CUSTOM_EPOCH = 1314220021721L;
    private static final int TIMESTAMP_BITS = 41;
    private static final int SHARD_ID_BITS = 13;
    private static final int SEQUENCE_BITS = 10;
    private static final int MAX_SHARD_ID = 8191;
    private static final int MAX_SEQUENCE = 1023;
    private static final long TIMESTAMP_LEFT_SHIFT = 23L;
    private static final long SHARD_ID_LEFT_SHIFT = 10L;
    private AtomicInteger sequence = new AtomicInteger(0);
    private long lastTimestamp = -1L;
    private int shardId;

    public InstagramIdGenerator(int shardId) {
        if (shardId < 0 || shardId > 8191) {
            throw new IllegalArgumentException("Shard ID exceeds its bit limit");
        }
        this.shardId = shardId;
    }

    public synchronized long generateId() {
        long currentTimestamp = this.getCurrentTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards. Refusing to generate id for " + (this.lastTimestamp - currentTimestamp) + " milliseconds");
        }
        if (currentTimestamp == this.lastTimestamp) {
            int currentSequence = this.sequence.getAndIncrement();
            if (currentSequence > 1023) {
                currentTimestamp = this.waitForNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence.set(0);
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1314220021721L << 23 | (long)(this.shardId << 10) | (long)this.sequence.getAndIncrement();
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    private long waitForNextMillis(long lastTimestamp) {
        long timestamp = this.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentTimestamp();
        }
        return timestamp;
    }

    public static void main(String[] args) {
        InstagramIdGenerator idGenerator = new InstagramIdGenerator(5);
        for (int i = 0; i < 10; ++i) {
            long id = idGenerator.generateId();
            System.out.println("Generated ID: " + id);
            System.out.println("Decomposed ID: " + InstagramIdGenerator.decomposeId(id));
        }
    }

    private static String decomposeId(long id) {
        long timestamp = (id >> 23) + 1314220021721L;
        int shardId = (int)(id >> 10 & 0x1FFFL);
        int sequence = (int)(id & 0x3FFL);
        return "Timestamp: " + timestamp + ", Shard ID: " + shardId + ", Sequence: " + sequence;
    }
}

