/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.sid;

import java.util.Base64;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.util.TimeUtils;

public class SIDGenerator
implements IdGenerator {
    private static final Random random = ThreadLocalRandom.current();

    private static byte[] longToBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return bytes;
    }

    @Override
    public Object generate() {
        return SIDGenerator.next();
    }

    public static String next() {
        byte[] timestamp = SIDGenerator.longToBytes(TimeUtils.getCurrentUnixNano());
        byte[] randomNum = SIDGenerator.longToBytes(random.nextLong());
        return Base64.getEncoder().encodeToString(timestamp) + "-" + Base64.getEncoder().encodeToString(randomNum);
    }

    @Override
    public IdType idType() {
        return IdType.SID;
    }
}

