/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.uuid;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class MonotonicRandomUUIDv7Generator {
    private static final LongAdder counter = new LongAdder();
    private static final AtomicLong lastTm = new AtomicLong(System.currentTimeMillis());

    public static UUID next(long add) {
        long currTm = System.currentTimeMillis() / 1000L;
        if (currTm > lastTm.get()) {
            lastTm.set(currTm);
            counter.reset();
        }
        long msb = System.currentTimeMillis() << 16 | 0x7000L | System.nanoTime() & 0xFFFL;
        long lsb = Long.MIN_VALUE | counter.sum() & 0x3FFFFFFFFFFFFFFFL;
        counter.add(add);
        return new UUID(msb, lsb);
    }

    public static UUID next() {
        return MonotonicRandomUUIDv7Generator.next(false);
    }

    public static UUID next(boolean unguessability) {
        if (unguessability) {
            return MonotonicRandomUUIDv7Generator.next(ThreadLocalRandom.current().nextLong());
        }
        return MonotonicRandomUUIDv7Generator.next(1L);
    }
}

