/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.uuid;

import java.security.SecureRandom;
import java.util.UUID;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public class UUIDv7Generator
implements IdGenerator {
    private static final SecureRandom random = new SecureRandom();
    private static final long HIGH_PART_RANDOM_MASK = 4095L;
    private static final long LOW_PART_RANDOM_MASK = 0x3FFFFFFFFFFFFFFFL;
    private static final long VERSION = 28672L;
    private static final long VARIANT = Long.MIN_VALUE;

    public static UUID next() {
        long timestampPart = System.currentTimeMillis() << 16;
        long highRandomPart = random.nextLong() & 0xFFFL;
        long msb = timestampPart | 0x7000L | highRandomPart;
        long lowRandomPart = random.nextLong() & 0x3FFFFFFFFFFFFFFFL;
        long lsb = Long.MIN_VALUE | lowRandomPart;
        return new UUID(msb, lsb);
    }

    @Override
    public String generate() {
        return UUIDv7Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv7;
    }
}

