/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.util;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import uno.xifan.id.util.IdGeneratorExecutors;

public class TimeUtils {
    private static volatile long cachedSeconds = 0L;

    public static long getCurrentUnixNano() {
        Instant now = Instant.now();
        long secondsInNanos = now.getEpochSecond() * 1000000000L;
        long nanos = now.getNano();
        return secondsInNanos + nanos;
    }

    public static long getCurrentUnixSeconds() {
        return cachedSeconds;
    }

    public static void main(String[] args) {
        long unixNano = TimeUtils.getCurrentUnixNano();
        System.out.println("\u5f53\u524d\u65f6\u95f4\u81ea Unix \u7eaa\u5143\u4ee5\u6765\u7684\u7eb3\u79d2\u6570: " + unixNano);
    }

    static {
        IdGeneratorExecutors.getScheduledExecutorService().scheduleAtFixedRate(() -> {
            cachedSeconds = Instant.now().getEpochSecond();
        }, 0L, 1L, TimeUnit.SECONDS);
    }
}

