# ObjectId 生成器

ObjectId 是 MongoDB 中用于生成唯一标识符的一种算法。它设计用于在分布式系统中生成全局唯一的标识符，特别适合用作文档的主键。

## 基本结构

ObjectId 是一个 12 字节的标识符，由以下部分组成：

- **时间戳部分**（4 字节）：表示 ObjectId 创建时的 Unix 时间戳（秒级）
- **随机值部分**（5 字节）：确保在同一秒内生成的 ID 具有唯一性
- **计数器部分**（3 字节）：一个自增计数器，用于保证同一进程同一秒内的唯一性

## 主要特性

1. **全局唯一性**

   - 通过组合时间戳、随机值和计数器，保证在分布式系统中的唯一性
   - 无需中央协调即可生成，避免了单点故障

2. **时间有序性**

   - 高位时间戳保证 ID 总体递增
   - 便于按时间范围查询和排序

3. **高性能**

   - 生成过程不需要网络请求
   - 本地生成，性能高效

4. **信息丰富**
   - 包含时间信息，可从 ID 本身提取生成时间
   - 便于问题追踪和数据分析

## 适用场景

1. **MongoDB 文档主键**

   - 作为 MongoDB 集合中文档的默认 \_id 字段
   - 适合分片集群环境

2. **分布式系统**

   - 多节点并行生成唯一 ID
   - 无需中央协调

3. **时序数据**
   - 需要按时间排序的数据集
   - 时间范围查询场景

## 优势对比

相比其他 ID 生成方案：

1. **vs UUID**

   - 更短的字节长度（12 字节 vs 16 字节）
   - 包含时间信息，支持时间排序

2. **vs 自增 ID**

   - 分布式友好，无需中央发号器
   - 自带时间信息

3. **vs 雪花算法**
   - 无需配置机器号
   - 更简单的实现方式

## 源代码参考

本实现参考自 MongoDB Java 驱动的官方实现：
https://github.com/mongodb/mongo-java-driver/blob/main/bson/src/main/org/bson/types/ObjectId.java

## 注意事项

1. 时间戳精度为秒级，对于需要毫秒级精度的场景可能不适用
2. ID 中包含随机成分，不保证严格单调递增
3. 在时钟回拨情况下仍能保持唯一性，但可能影响时间有序性
