/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.base;

public class Base36 {
    private static final byte[] ENCODE_MAP;
    private static final byte[] DECODE_MAP;

    public static String encode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return String.valueOf((char)ENCODE_MAP[0]);
        }
        StringBuilder result = new StringBuilder();
        int value = 0;
        int bits = 0;
        for (byte b : bytes) {
            value = value << 8 | b & 0xFF;
            bits += 8;
            while (bits >= 6) {
                int index = value >> (bits -= 6) & 0x3F;
                if (index >= 36) {
                    index = 35;
                }
                result.append((char)ENCODE_MAP[index]);
                value &= (1 << bits) - 1;
            }
        }
        if (bits > 0) {
            int index = value << 6 - bits & 0x3F;
            if (index >= 36) {
                index = 35;
            }
            result.append((char)ENCODE_MAP[index]);
        }
        return result.length() > 0 ? result.toString() : String.valueOf((char)ENCODE_MAP[0]);
    }

    public static byte[] decode(String base36) {
        if (base36 == null || base36.isEmpty()) {
            throw new IllegalArgumentException("Input string cannot be null or empty");
        }
        int bitsPerChar = 6;
        int totalBits = base36.length() * bitsPerChar;
        int byteCount = (totalBits + 7) / 8;
        byte[] bytes = new byte[byteCount];
        int bitBuffer = 0;
        int bitsInBuffer = 0;
        int byteIndex = 0;
        for (int i = 0; i < base36.length(); ++i) {
            char c = base36.charAt(i);
            if (c >= DECODE_MAP.length || DECODE_MAP[c] < 0) {
                throw new IllegalArgumentException("Invalid character in Base36 string: " + c);
            }
            bitBuffer = bitBuffer << 6 | DECODE_MAP[c];
            bitsInBuffer += 6;
            while (bitsInBuffer >= 8 && byteIndex < bytes.length) {
                bytes[byteIndex++] = (byte)(bitBuffer >> (bitsInBuffer -= 8) & 0xFF);
            }
        }
        if (bitsInBuffer > 0 && byteIndex < bytes.length) {
            bytes[byteIndex] = (byte)(bitBuffer << 8 - bitsInBuffer & 0xFF);
        }
        return bytes;
    }

    static {
        int i;
        ENCODE_MAP = new byte[36];
        DECODE_MAP = new byte[128];
        int index = 0;
        for (i = 48; i <= 57; i = (int)((byte)(i + 1))) {
            Base36.ENCODE_MAP[index++] = i;
        }
        for (i = 65; i <= 90; i = (int)((byte)(i + 1))) {
            Base36.ENCODE_MAP[index++] = i;
        }
        for (i = 0; i < ENCODE_MAP.length; ++i) {
            Base36.DECODE_MAP[Base36.ENCODE_MAP[i]] = (byte)i;
            if (!Character.isLetter((char)ENCODE_MAP[i])) continue;
            Base36.DECODE_MAP[Character.toLowerCase((char)((char)Base36.ENCODE_MAP[i]))] = (byte)i;
        }
    }
}

