/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.combguid;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public class CombGuidGenerator
implements IdGenerator {
    public static UUID next() {
        long msb = ThreadLocalRandom.current().nextLong();
        long lsb = ThreadLocalRandom.current().nextLong();
        msb &= 0xFFFFFFFFFFFF0FFFL;
        lsb &= 0x3FFFFFFFFFFFFFFFL;
        long timestamp = System.currentTimeMillis();
        long newMsb = (timestamp & 0xFFFFFFFFFFFFL) << 16 | (msb |= 0x4000L) & 0xFFFFL;
        return new UUID(newMsb, lsb |= Long.MIN_VALUE);
    }

    @Override
    public String generate() {
        return CombGuidGenerator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.COMBGUID;
    }
}

