/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.flake;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public class FlakeIdGenerator
implements IdGenerator {
    private static final long EPOCH = 1609459200000L;
    private static final int WORKER_ID_BITS = 48;
    private static final int SEQUENCE_BITS = 16;
    private static final int MAX_WORKER_ID = 65535;
    private static final int MAX_SEQUENCE = 65535;
    private static final FlakeIdGenerator INSTANCE = new FlakeIdGenerator();
    private final long workerId = this.getWorkerId();
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public static void main(String[] args) {
        FlakeIdGenerator generator = new FlakeIdGenerator();
        for (int i = 0; i < 10; ++i) {
            System.out.println(generator.generateFlakeId());
        }
    }

    private long getWorkerId() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                byte[] macBytes;
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || (macBytes = networkInterface.getHardwareAddress()) == null) continue;
                long workerId = 0L;
                for (byte b : macBytes) {
                    workerId = workerId << 8 | (long)(b & 0xFF);
                }
                return workerId &= 0xFFFFL;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public synchronized long generateFlakeId() {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp < this.lastTimestamp) {
            throw new RuntimeException("\u65f6\u949f\u56de\u62e8\u5f02\u5e38");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.waitNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1609459200000L << 64 | this.workerId << 16 | this.sequence;
    }

    private long waitNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    @Override
    public Long generate() {
        return INSTANCE.generateFlakeId();
    }

    @Override
    public IdType idType() {
        return IdType.Flake;
    }
}

