/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.flakeid;

import java.nio.ByteBuffer;
import java.util.Date;

public class FlakeId {
    private static final long POW10 = 1024L;
    private static final long POW26 = 0x4000000L;
    private final Options options;
    private final long id;
    private final long genId;
    private final long epoch;
    private final long seqMask;
    private long seq;
    private long lastTime;
    private boolean overflow;

    public FlakeId(Options options) {
        Options options2 = this.options = options != null ? options : new Options();
        if (this.options.id != null) {
            this.id = this.options.id & 0x3FFL;
        } else {
            long datacenter = (this.options.datacenter != null ? this.options.datacenter : 0L) & 0x1FL;
            long worker = (this.options.worker != null ? this.options.worker : 0L) & 0x1FL;
            this.id = datacenter << 5 | worker;
        }
        this.genId = this.id << 12;
        this.epoch = this.options.epoch != null ? this.options.epoch : 0L;
        this.seq = 0L;
        this.lastTime = 0L;
        this.overflow = false;
        this.seqMask = this.options.seqMask != null ? this.options.seqMask : 4095L;
    }

    public byte[] next() throws Exception {
        byte[] id = new byte[8];
        long time = new Date().getTime() - this.epoch;
        if (time < this.lastTime) {
            throw new Exception("Clock moved backwards. Refusing to generate id for " + (this.lastTime - time) + " milliseconds");
        }
        if (time == this.lastTime) {
            if (this.overflow) {
                this.waitForNextMillis();
                return this.next();
            }
            this.seq = this.seq + 1L & this.seqMask;
            if (this.seq == 0L) {
                this.overflow = true;
                this.waitForNextMillis();
                return this.next();
            }
        } else {
            this.overflow = false;
            this.seq = 0L;
        }
        this.lastTime = time;
        ByteBuffer buffer = ByteBuffer.wrap(id);
        buffer.putInt(4, (int)((time & 3L) << 22 | this.genId | this.seq));
        buffer.put(4, (byte)(time >> 2 & 0xFFL));
        buffer.putShort(2, (short)(time >> 10 & 0xFFFFL));
        buffer.putShort(0, (short)(time >> 26 & 0xFFFFL));
        return id;
    }

    private void waitForNextMillis() throws InterruptedException {
        long currentTime = new Date().getTime();
        while (currentTime <= this.lastTime) {
            currentTime = new Date().getTime();
            Thread.sleep(1L);
        }
        this.lastTime = currentTime;
        this.overflow = false;
        this.seq = 0L;
    }

    public static class Options {
        public Long id;
        public Long datacenter;
        public Long worker;
        public Long epoch;
        public Long seqMask;
    }
}

