/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.flexid;

import java.util.concurrent.ThreadLocalRandom;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public class FlexIDKeyGenerator
implements IdGenerator {
    private static final long INITIAL_TIMESTAMP = 1680411660000L;
    private static final long MAX_CLOCK_SEQ = 99L;
    private long lastTimeMillis = 0L;
    private long clockSeq = 0L;
    private long workId = 1L;

    public FlexIDKeyGenerator() {
    }

    public FlexIDKeyGenerator(long workId) {
        this.workId = workId;
    }

    private synchronized long nextId() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis == this.lastTimeMillis) {
            ++this.clockSeq;
            if (this.clockSeq > 99L) {
                this.clockSeq = 0L;
                ++currentTimeMillis;
            }
        } else if (currentTimeMillis < this.lastTimeMillis) {
            currentTimeMillis = this.lastTimeMillis;
            ++this.clockSeq;
            if (this.clockSeq > 99L) {
                this.clockSeq = 0L;
                ++currentTimeMillis;
            }
        } else {
            this.clockSeq = 0L;
        }
        this.lastTimeMillis = currentTimeMillis;
        long diffTimeMillis = currentTimeMillis - 1680411660000L;
        return diffTimeMillis * 1000000L + this.clockSeq * 10000L + this.workId * 100L + (long)this.getRandomInt();
    }

    private int getRandomInt() {
        return ThreadLocalRandom.current().nextInt(100);
    }

    @Override
    public Long generate() {
        return this.nextId();
    }

    @Override
    public IdType idType() {
        return IdType.FlexId;
    }
}

