/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.ksuid;

import java.time.Instant;
import uno.xifan.id.generator.ksuid.Ksuid;
import uno.xifan.id.generator.ksuid.KsuidFactory;

public final class KsuidCreator {
    private KsuidCreator() {
    }

    public static Ksuid getKsuid() {
        return FactoryHolder.INSTANCE.create();
    }

    public static Ksuid getSubsecondKsuid() {
        return SubsecondHolder.INSTANCE.create();
    }

    public static Ksuid getMonotonicKsuid() {
        return MonotonicHolder.INSTANCE.create();
    }

    public static Ksuid getKsuid(Instant instant) {
        return FactoryHolder.INSTANCE.create(instant);
    }

    public static Ksuid getSubsecondKsuid(Instant instant) {
        return SubsecondHolder.INSTANCE.create(instant);
    }

    public static Ksuid getMonotonicKsuid(Instant instant) {
        return MonotonicHolder.INSTANCE.create(instant);
    }

    private static class FactoryHolder {
        static final KsuidFactory INSTANCE = KsuidFactory.newInstance();

        private FactoryHolder() {
        }
    }

    private static class SubsecondHolder {
        static final KsuidFactory INSTANCE = KsuidFactory.newSubsecondInstance();

        private SubsecondHolder() {
        }
    }

    private static class MonotonicHolder {
        static final KsuidFactory INSTANCE = KsuidFactory.newMonotonicInstance();

        private MonotonicHolder() {
        }
    }
}

