/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.mist;

import java.security.SecureRandom;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.mist.MistGenerator;

public class SecureMistGenerator
implements MistGenerator {
    private static final int SALT_BIT = 8;
    private static final int SALT_SHIFT = 8;
    private static final int INCREAS_SHIFT = 16;
    private static final int MAX_SALT_VALUE = 255;
    private long increas = 1L;
    private final SecureRandom random = new SecureRandom();

    @Override
    public synchronized Long generate() {
        this.random.ints();
        long increasValue = ++this.increas;
        long saltA = this.random.nextInt(256);
        long saltB = this.random.nextInt(256);
        return increasValue << 16 | saltA << 8 | saltB;
    }

    public static SecureMistGenerator getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public IdType idType() {
        return IdType.MIST_ID;
    }

    private static class SingletonHolder {
        private static final SecureMistGenerator INSTANCE = new SecureMistGenerator();

        private SingletonHolder() {
        }
    }
}

