/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.ordereduuid;

import java.time.Instant;
import java.util.UUID;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public class OrderedUuidGenerator
implements IdGenerator {
    public static UUID next() {
        UUID uuid = UUID.randomUUID();
        long timestamp = Instant.now().toEpochMilli();
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long newMsb = (timestamp & 0xFFFFFFFFFFFFL) << 16 | msb & 0xFFFFL;
        return new UUID(newMsb, lsb);
    }

    @Override
    public String generate() {
        return OrderedUuidGenerator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.OrderedUuid;
    }
}

