/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.ulid;

import java.security.SecureRandom;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public final class ULIDGenerator
implements IdGenerator {
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final int MASK = 31;
    private static final int MASK_BITS = 5;
    private static final long TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
    private static final long TIMESTAMP_MSB_MASK = -65536L;
    private static final long RANDOM_MSB_MASK = 65535L;
    private static final long HALF_RANDOM_COMPONENT = 0xFFFFFFFFFFL;
    private static final long MAX_INCREMENT = 0x10000000000L;
    private static final long TIMESTAMP_MAX = (long)Math.pow(2.0, 48.0) - 1L;
    private static final byte A = 6;
    private static final byte B = 127;
    private static final byte C = -72;
    private static final byte D = -63;
    private long v0 = 0L;
    private long v1 = 0L;
    private long v2 = 0L;
    private long v3 = 0L;
    private long lastUsedTimestamp;
    private long randomMaxMsb;
    private long randomMaxLsb;
    private long randomMsb = 0L;
    private long randomLsb = 0L;
    private final SecureRandom randomGenerator;

    public ULIDGenerator() {
        this(new SecureRandom());
    }

    public ULIDGenerator(SecureRandom random) {
        this.randomGenerator = random;
        this.reseed();
    }

    public String create() {
        long k0 = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)6);
        long k1 = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)127);
        long msb = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)-72) & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)-63) << 2 >>> 2 | Long.MIN_VALUE;
        this.reseed(k0, k1);
        return ULIDGenerator.asString(System.currentTimeMillis(), msb, lsb);
    }

    public String next() {
        long timestamp = this.getTimestamp();
        long msbRandom = this.randomMsb & 0xFFFFFFFFFFL;
        long lsbRandom = this.randomLsb & 0xFFFFFFFFFFL;
        long msb = timestamp << 16 | msbRandom >>> 24;
        long lsb = msbRandom << 40 | lsbRandom;
        return ULIDGenerator.asString(msb, lsb);
    }

    public void reseed() {
        byte[] seed = new byte[128];
        this.randomGenerator.nextBytes(seed);
        this.reseed(this.randomGenerator.nextLong(), this.randomGenerator.nextLong());
    }

    private void reseed(long k0, long k1) {
        this.v0 = k0 ^ 0x736F6D6570736575L;
        this.v1 = k1 ^ 0x646F72616E646F6DL;
        this.v2 = k0 ^ 0x6C7967656E657261L;
        this.v3 = k1 ^ 0x7465646279746573L;
    }

    private long getTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (timestamp == this.lastUsedTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.lastUsedTimestamp = timestamp;
        return timestamp;
    }

    private synchronized void reset() {
        long k0 = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)6);
        long k1 = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)127);
        this.randomMsb = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)-72) & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        this.randomLsb = ULIDGenerator.sipHash24(this.v0, this.v1, this.v2, this.v3, (byte)-63) << 2 >>> 2 | Long.MIN_VALUE;
        this.reseed(k0, k1);
        this.randomMaxMsb = this.randomMsb | 0x10000000000L;
        this.randomMaxLsb = this.randomLsb | 0x10000000000L;
    }

    private synchronized void increment() {
        if (++this.randomLsb >= this.randomMaxLsb) {
            this.randomLsb &= 0xFFFFFFFFFFL;
            if (++this.randomMsb >= this.randomMaxMsb) {
                this.reset();
            }
        }
    }

    private static String asString(long timestamp, long msb, long lsb) {
        ULIDGenerator.checkTimestamp(timestamp);
        return ULIDGenerator.crockfordBase32(timestamp, msb, lsb);
    }

    private static String asString(long msb, long lsb) {
        long time = (msb & 0xFFFFFFFFFFFF0000L) >>> 16;
        long random1 = (msb & 0xFFFFL) << 24 | (lsb & 0xFFFFFF0000000000L) >>> 40;
        long random2 = lsb & 0xFFFFFFFFFFL;
        return ULIDGenerator.crockfordBase32(time, random1, random2);
    }

    private static String crockfordBase32(long timeComponent, long msb, long lsb) {
        char[] buffer = new char[]{ENCODING_CHARS[(int)(timeComponent >>> 45 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 40 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 35 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 30 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 25 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 20 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 15 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 10 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 5 & 0x1FL)], ENCODING_CHARS[(int)(timeComponent >>> 0 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 35 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 30 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 25 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 20 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 15 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 10 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 5 & 0x1FL)], ENCODING_CHARS[(int)(msb >>> 0 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 35 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 30 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 25 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 20 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 15 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 10 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 5 & 0x1FL)], ENCODING_CHARS[(int)(lsb >>> 0 & 0x1FL)]};
        return new String(buffer);
    }

    private static long sipHash24(long v0, long v1, long v2, long v3, byte data) {
        int i;
        long m = (long)data & 0xFFL | 0x100000000000000L;
        v3 ^= m;
        for (i = 0; i < 2; ++i) {
            v0 += v1;
            v2 += v3;
            v1 = Long.rotateLeft(v1, 13);
            v3 = Long.rotateLeft(v3, 16);
            v1 ^= v0;
            v3 ^= v2;
            v0 = Long.rotateLeft(v0, 32);
            v2 += v1;
            v0 += v3;
            v1 = Long.rotateLeft(v1, 17);
            v3 = Long.rotateLeft(v3, 21);
            v1 ^= v2;
            v3 ^= v0;
            v2 = Long.rotateLeft(v2, 32);
        }
        v0 ^= m;
        v2 ^= 0xFFL;
        for (i = 0; i < 4; ++i) {
            v0 += v1;
            v2 += v3;
            v1 = Long.rotateLeft(v1, 13);
            v3 = Long.rotateLeft(v3, 16);
            v1 ^= v0;
            v3 ^= v2;
            v0 = Long.rotateLeft(v0, 32);
            v2 += v1;
            v0 += v3;
            v1 = Long.rotateLeft(v1, 17);
            v3 = Long.rotateLeft(v3, 21);
            v1 ^= v2;
            v3 ^= v0;
            v2 = Long.rotateLeft(v2, 32);
        }
        return v0 ^ v1 ^ v2 ^ v3;
    }

    private static void checkTimestamp(long timestamp) {
        if ((timestamp & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }

    public static long unixTime(String ulidStr) {
        char[] tb = ulidStr.toCharArray();
        char[] timestampComponent = new char[10];
        System.arraycopy(tb, 0, timestampComponent, 0, 10);
        return ULIDGenerator.toLong(timestampComponent);
    }

    public static boolean isValid(String ulidStr) {
        if (ulidStr == null) {
            return false;
        }
        char[] chars = ulidStr.toCharArray();
        if (chars.length != 26 || !ULIDGenerator.containsValidBase32Chars(chars)) {
            return false;
        }
        long timestamp = ULIDGenerator.unixTime(ulidStr);
        return timestamp >= 0L && timestamp <= TIMESTAMP_MAX;
    }

    protected static long toLong(char[] input) {
        long n = 0L;
        for (char c : input) {
            int d = ULIDGenerator.decodeBase32(c);
            n = 32L * n + (long)d;
        }
        return n;
    }

    private static int decodeBase32(char c) {
        for (int i = 0; i < ENCODING_CHARS.length; ++i) {
            if (ENCODING_CHARS[i] != c) continue;
            return (byte)i;
        }
        return 48;
    }

    private static boolean containsValidBase32Chars(char[] chars) {
        char[] input;
        for (char c : input = ULIDGenerator.toUpperCase(chars)) {
            if (ULIDGenerator.isBase32Char(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBase32Char(char c) {
        for (char encodingChar : ENCODING_CHARS) {
            if (c != encodingChar) continue;
            return true;
        }
        return false;
    }

    private static char[] toUpperCase(char[] input) {
        char[] output = new char[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = Character.toUpperCase(input[i]);
        }
        return output;
    }

    @Override
    public Object generate() {
        return this.next();
    }

    @Override
    public IdType idType() {
        return IdType.ULID;
    }
}

