/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.uuid;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

public class UUIDv4Generator
implements IdGenerator {
    private static final long VERSION_IDENTIFIER = 16384L;
    private static final long VARIANT_IDENTIFIER = Long.MIN_VALUE;

    public static UUID next() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        long msb = random.nextLong();
        long lsb = random.nextLong();
        msb = msb & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        lsb = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }

    @Override
    public Object generate() {
        return UUIDv4Generator.next().toString();
    }

    @Override
    public IdType idType() {
        return IdType.UUIDv4;
    }
}

