package uno.xifan.id.generator.distributed.segmentid;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.concurrent.atomic.AtomicLong;

@Data
@NoArgsConstructor
public class IdSegment {
    private long start;
    private long end;

    private final AtomicLong current =  new AtomicLong(0);

    public boolean isOverflow() {
        return current.get() >= end;
    }

    public long next() {
        return current.getAndIncrement();
    }
}
