/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.mist;

import java.util.Random;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributed.mist.MistId;
import uno.xifan.id.generator.distributed.segmentid.concurrent.IdSegmentChain;

@Component
public class MistIdGenerator
implements IdGenerator {
    @Generated
    private static final Logger log = LogManager.getLogger(MistIdGenerator.class);
    private final Random random = new Random();
    private final IdSegmentChain idSegmentChain;

    public MistIdGenerator(RedissonClient redisson) {
        RAtomicLong atomicLong = redisson.getAtomicLong("IdGenerator:MistIdGenerator:NextMaxId");
        if (!atomicLong.isExists()) {
            atomicLong.set(0L);
        }
        this.idSegmentChain = new IdSegmentChain(atomicLong);
    }

    public MistId generate() {
        return new MistId(this.idSegmentChain.nextId(), this.random.nextInt(0, 65535));
    }

    public IdType idType() {
        return IdType.MIST_ID;
    }
}

