/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.rid;

import jakarta.annotation.PostConstruct;
import org.redisson.api.RIdGenerator;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;

@Component
public class RedissonIdGenerator
implements IdGenerator {
    private final RIdGenerator generator;

    public RedissonIdGenerator(RedissonClient redisson, @Value(value="${id.generator.rid.name:IdGenerator:RedissonIdGenerator:current}") String name, @Value(value="${id.generator.rid.value:0}") long value, @Value(value="${id.generator.rid.allocationSize:5000}") long allocationSize) {
        this.generator = redisson.getIdGenerator(name);
        this.generator.tryInit(value, allocationSize);
    }

    @PostConstruct
    public void init() {
    }

    public Long generate() {
        return this.generator.nextId();
    }

    public IdType idType() {
        return IdType.RID;
    }
}

