/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.segmentid.concurrent;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RingBuffer<T> {
    private final T[] buffer;
    private int head = 0;
    private int tail = 0;
    private int count = 0;
    private final int capacity;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.buffer = new Object[capacity];
    }

    public void put(T item) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == this.capacity) {
                this.notFull.await();
            }
            this.buffer[this.tail] = item;
            this.tail = (this.tail + 1) % this.capacity;
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            T item = this.buffer[this.head];
            this.head = (this.head + 1) % this.capacity;
            --this.count;
            this.notFull.signal();
            T t = item;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offer(T item) {
        this.lock.lock();
        try {
            if (this.count == this.capacity) {
                boolean bl = false;
                return bl;
            }
            this.buffer[this.tail] = item;
            this.tail = (this.tail + 1) % this.capacity;
            ++this.count;
            this.notEmpty.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T poll() {
        this.lock.lock();
        try {
            if (this.count == 0) {
                T t = null;
                return t;
            }
            T item = this.buffer[this.head];
            this.head = (this.head + 1) % this.capacity;
            --this.count;
            this.notFull.signal();
            T t = item;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.count == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFull() {
        this.lock.lock();
        try {
            boolean bl = this.count == this.capacity;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

