/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.snowflake;

import java.util.concurrent.atomic.AtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributor.MachineIdDistributor;

@Component
public class LockFreeSnowflakeIdGenerator
implements IdGenerator {
    private final long epoch;
    private final int timestampBits;
    private final int machineIdBits;
    private final int sequenceBits;
    private final AtomicLong lastTimestamp = new AtomicLong(-1L);
    private final MachineIdDistributor machineIdDistributor;
    private final AtomicLong sequence = new AtomicLong(0L);

    public LockFreeSnowflakeIdGenerator(RedissonClient redissonClient, @Value(value="${id.generator.snowflake.epoch:1645557742000}") long epoch, @Value(value="${id.generator.snowflake.timestamp:41}") int timestampBits, @Value(value="${id.generator.snowflake.machine:10}") int machineIdBits, @Value(value="${id.generator.snowflake.sequence:12}") int sequenceBits) {
        this.epoch = epoch;
        this.timestampBits = timestampBits;
        this.machineIdBits = machineIdBits;
        this.sequenceBits = sequenceBits;
        this.machineIdDistributor = new MachineIdDistributor(redissonClient, IdType.Snowflake.getName(), machineIdBits);
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    public Long generate() {
        long currentSequence;
        long timestamp;
        long currentLastTimestamp;
        do {
            currentLastTimestamp = this.lastTimestamp.get();
            timestamp = this.timeGen();
            if (timestamp < currentLastTimestamp) {
                throw new RuntimeException("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID");
            }
            if (timestamp == currentLastTimestamp) {
                currentSequence = this.sequence.updateAndGet(seq -> seq + 1L & (-1L << this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL));
                if (currentSequence != 0L) continue;
                timestamp = this.tilNextMillis(currentLastTimestamp);
                continue;
            }
            this.sequence.set(0L);
            currentSequence = 0L;
        } while (!this.lastTimestamp.compareAndSet(currentLastTimestamp, timestamp));
        return timestamp - this.epoch << this.machineIdBits + this.sequenceBits | this.machineIdDistributor.get() << this.sequenceBits | currentSequence;
    }

    public IdType idType() {
        return IdType.Snowflake;
    }
}

