/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributed.ttsid.TtsIdMini;
import uno.xifan.id.generator.distributed.ttsid.TtsIdMiniGeneratorConfig;

@Component
public class TtsIdMiniGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdThreadLocalHolder> threadLocalHolder;

    public TtsIdMiniGenerator(RedissonClient redisson, TtsIdMiniGeneratorConfig config) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdMiniGenerator:%s:NextThreadId".formatted(config.getNamespace()));
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdThreadLocalHolder(Math.abs(threadId.getAndIncrement() % 1024L)));
    }

    public TtsIdMini generate() {
        TtsIdThreadLocalHolder holder = this.threadLocalHolder.get();
        return holder.next();
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static final class TtsIdThreadLocalHolder {
        private final long threadId;
        private long sequence = 0L;
        private long lastTimestamp = TtsIdMini.currentTimestamp();

        private TtsIdThreadLocalHolder(long threadId) {
            this.threadId = threadId;
        }

        private TtsIdMini next() {
            long timestamp = TtsIdMini.currentTimestamp();
            if (timestamp < this.lastTimestamp) {
                timestamp = this.waitNextSecond(this.lastTimestamp);
            } else if (timestamp == this.lastTimestamp) {
                ++this.sequence;
                if (this.sequence >= 4096L) {
                    timestamp = this.waitNextSecond(this.lastTimestamp);
                    this.sequence = 0L;
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return new TtsIdMini(timestamp, this.threadId, this.sequence);
        }

        private long waitNextSecond(long lastTimestamp) {
            long timestamp = TtsIdMini.currentTimestamp();
            while (timestamp <= lastTimestamp) {
                timestamp = TtsIdMini.currentTimestamp();
            }
            return timestamp;
        }
    }
}

