/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import java.nio.ByteBuffer;
import java.util.HexFormat;
import uno.xifan.id.base.Id;
import uno.xifan.id.generator.util.CrockfordBase32Encoder;

public record TtsIdPlus(long timestamp, int threadId, short sequence) implements Id
{
    public static long currentTimestamp() {
        return System.currentTimeMillis();
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put((byte)(this.timestamp >>> 36));
        buffer.put((byte)(this.timestamp >>> 28));
        buffer.put((byte)(this.timestamp >>> 20));
        buffer.put((byte)(this.timestamp >>> 12));
        buffer.put((byte)(this.timestamp >>> 4));
        byte mixed1 = (byte)((this.timestamp & 0xFL) << 4 | (long)(this.threadId >>> 16 & 0xF));
        buffer.put(mixed1);
        buffer.put((byte)(this.threadId >>> 8));
        buffer.put((byte)this.threadId);
        buffer.put((byte)(this.sequence >>> 8));
        buffer.put((byte)this.sequence);
        return buffer.array();
    }

    public long toLong() {
        throw new UnsupportedOperationException("TtsIdPlus (80-bit) cannot be represented as a 64-bit long");
    }

    public String toBase32() {
        return CrockfordBase32Encoder.encode80Bit(this.toBytes());
    }

    public String toBase16() {
        return HexFormat.of().formatHex(this.toBytes());
    }
}

