/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HexFormat;
import uno.xifan.id.base.Id;

public record TtsIdPro(long timestamp, int threadId, short sequence) implements Id
{
    public static long currentTimestamp() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000L + (long)(now.getNano() / 1000);
    }

    public byte[] toBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.put((byte)(this.timestamp >>> 48));
        buffer.put((byte)(this.timestamp >>> 40));
        buffer.put((byte)(this.timestamp >>> 32));
        buffer.put((byte)(this.timestamp >>> 24));
        buffer.put((byte)(this.timestamp >>> 16));
        buffer.put((byte)(this.timestamp >>> 8));
        buffer.put((byte)this.timestamp);
        buffer.put((byte)(this.threadId >>> 16));
        buffer.put((byte)(this.threadId >>> 8));
        buffer.put((byte)this.threadId);
        buffer.put((byte)(this.sequence >>> 8));
        buffer.put((byte)this.sequence);
        return buffer.array();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public String toBase16() {
        return HexFormat.of().formatHex(this.toBytes());
    }
}

