/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.HexFormat;
import uno.xifan.id.base.Id;

public record TtsIdProMax(long timestamp, int threadId, int sequence) implements Id
{
    public static long currentTimestamp() {
        Instant instant = Instant.now();
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public byte[] toBytes() {
        return ByteBuffer.allocate(16).putLong(this.timestamp).putInt(this.threadId).putInt(this.sequence).array();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public String toBase16() {
        return HexFormat.of().formatHex(this.toBytes());
    }
}

