/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributor;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MachineIdDistributor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachineIdDistributor.class);
    private final RSetCache<Long> set;
    private final String namespace;
    private final long machineId;
    private final Random random = new SecureRandom();

    public MachineIdDistributor(RedissonClient redisson, String namespace, int bits) {
        this.namespace = namespace;
        this.set = redisson.getSetCache(String.format("IdGenerator:MachineIdDistributor:%s:Set", namespace));
        this.machineId = this.register(bits);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        scheduler.scheduleAtFixedRate(this::renewLease, 10L, 20L, TimeUnit.SECONDS);
    }

    public void renewLease() {
        this.set.add((Object)this.machineId, 60L, TimeUnit.SECONDS);
        log.info("{} renew machine id:{}", (Object)this.namespace, (Object)this.machineId);
    }

    public long register(int bits) {
        long id;
        while (!this.set.add((Object)(id = this.random.nextLong() & (1L << bits) - 1L), 60L, TimeUnit.SECONDS)) {
        }
        log.info("{} register machine id:{}", (Object)this.namespace, (Object)id);
        return id;
    }

    public long get() {
        return this.machineId;
    }
}

