/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributor;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonClient;
import uno.xifan.id.util.IdGeneratorExecutors;

public class ThreadIdDistributor {
    @Generated
    private static final Logger log = LogManager.getLogger(ThreadIdDistributor.class);
    private final RSetCache<Long> set;
    private final RAtomicLong atomicLong;
    private final String namespace;
    private final long threadId;

    public ThreadIdDistributor(RedissonClient redisson, String namespace, int bits) {
        this.namespace = namespace;
        this.set = redisson.getSetCache(String.format("IdGenerator:ThreadIdDistributor:%s:Set", namespace));
        this.atomicLong = redisson.getAtomicLong(String.format("IdGenerator:ThreadIdDistributor:%s:AtomicLong", namespace));
        this.threadId = this.register(bits);
        IdGeneratorExecutors.getScheduledExecutorService().scheduleWithFixedDelay(this::renewLease, 15L, 30L, TimeUnit.SECONDS);
    }

    public void renewLease() {
        this.set.add((Object)this.threadId, 60L, TimeUnit.SECONDS);
        log.info("{} renew thread id:{}", (Object)this.namespace, (Object)this.threadId);
    }

    public long register(int bits) {
        long id;
        while (!this.set.add((Object)(id = Math.abs(this.atomicLong.getAndIncrement() % (1L << bits))), 60L, TimeUnit.SECONDS)) {
        }
        log.info("{} register thread id:{}", (Object)this.namespace, (Object)id);
        return id;
    }

    public long get() {
        return this.threadId;
    }
}

