/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.util;

import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import uno.xifan.id.generator.util.time.NtpClient;

public class Clock {
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static long now = System.currentTimeMillis();

    public static void sync() {
        Instant instant;
        try {
            instant = NtpClient.getTime("pool.ntp.org");
        }
        catch (Exception e) {
            instant = Instant.now();
        }
        now = instant.getEpochSecond() * 1000000000L + (long)instant.getNano() + System.nanoTime();
    }

    public static long currentTimeNanos() {
        return now - System.nanoTime();
    }

    public static long currentTimeSeconds() {
        return Clock.currentTimeNanos() / 1000000000L;
    }

    public static long currentTimeMicros() {
        return Clock.currentTimeNanos() / 1000L;
    }

    public static long currentTimeMillis() {
        return Clock.currentTimeNanos() / 1000000L;
    }

    static {
        Clock.sync();
        scheduler.scheduleWithFixedDelay(Clock::sync, 64L, 1024L, TimeUnit.SECONDS);
    }
}

