/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.util.time;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class NtpClient {
    private static final int NTP_PORT = 123;
    private static final int NTP_PACKET_SIZE = 48;
    private static final long NTP_TIMESTAMP_OFFSET = 2208988800L;

    public static Instant getTime(String server) throws Exception {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.setSoTimeout(5000);
            byte[] buffer = new byte[48];
            buffer[0] = 27;
            InetAddress address = InetAddress.getByName(server);
            DatagramPacket request = new DatagramPacket(buffer, buffer.length, address, 123);
            socket.send(request);
            DatagramPacket response = new DatagramPacket(buffer, buffer.length);
            socket.receive(response);
            long seconds = NtpClient.read32(buffer, 40);
            long fraction = NtpClient.read32(buffer, 44);
            Instant instant = Instant.ofEpochSecond(seconds - 2208988800L).plusNanos(fraction * 1000000000L >>> 32);
            return instant;
        }
    }

    public static OffsetDateTime getTimeWithOffset(String server, ZoneOffset offset) throws Exception {
        return NtpClient.getTime(server).atOffset(offset);
    }

    private static long read32(byte[] buffer, int offset) {
        return (long)(buffer[offset] & 0xFF) << 24 | (long)((buffer[offset + 1] & 0xFF) << 16) | (long)((buffer[offset + 2] & 0xFF) << 8) | (long)(buffer[offset + 3] & 0xFF);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("NTP\u65f6\u95f4\u540c\u6b65\u6d4b\u8bd5\uff1a");
        Instant time = NtpClient.getTime("pool.ntp.org");
        System.out.println("UTC\u65f6\u95f4\uff1a" + String.valueOf(time));
        System.out.println("\u672c\u5730\u65f6\u95f4\uff1a" + String.valueOf(time.atOffset(ZoneOffset.systemDefault().getRules().getOffset(time))));
    }
}

