/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.dtsid;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import uno.xifan.id.base.Id;

public class DtsId
implements Id {
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private long timestamp;
    private long sequence;

    public byte[] toBytes() {
        return this.long2bytes(this.toLong());
    }

    public long toLong() {
        String formatted = LocalDateTime.ofInstant(Instant.ofEpochSecond(this.timestamp), ZoneId.systemDefault()).format(dateTimeFormatter);
        return Long.parseLong(formatted) * 100000L + this.sequence % 100000L;
    }

    @Generated
    public DtsId(long timestamp, long sequence) {
        this.timestamp = timestamp;
        this.sequence = sequence;
    }

    @Generated
    public String toString() {
        return "DtsId(timestamp=" + this.timestamp + ", sequence=" + this.sequence + ")";
    }
}

