/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.segmentid.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentRingBuffer<T> {
    private final T[] buffer;
    private int head;
    private int tail;
    private int count;
    private final int capacity;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final boolean overwrite;

    public ConcurrentRingBuffer(int capacity, boolean overwrite, boolean fair) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.capacity = capacity;
        this.buffer = new Object[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.overwrite = overwrite;
    }

    public ConcurrentRingBuffer(int capacity, boolean overwrite) {
        this(capacity, overwrite, false);
    }

    public void put(T item) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == this.capacity && !this.overwrite) {
                this.notFull.await();
            }
            if (this.count == this.capacity && this.overwrite) {
                this.buffer[this.tail] = item;
                this.head = (this.head + 1) % this.capacity;
                this.tail = (this.tail + 1) % this.capacity;
                this.notEmpty.signal();
            } else {
                this.buffer[this.tail] = item;
                this.tail = (this.tail + 1) % this.capacity;
                ++this.count;
                this.notEmpty.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(T item, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (this.count == this.capacity && !this.overwrite) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            if (this.count == this.capacity && this.overwrite) {
                this.buffer[this.tail] = item;
                this.head = (this.head + 1) % this.capacity;
                this.tail = (this.tail + 1) % this.capacity;
                this.notEmpty.signal();
            } else {
                this.buffer[this.tail] = item;
                this.tail = (this.tail + 1) % this.capacity;
                ++this.count;
                this.notEmpty.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean offer(T item) {
        this.lock.lock();
        try {
            if (this.count == this.capacity && !this.overwrite) {
                boolean bl = false;
                return bl;
            }
            if (this.count == this.capacity && this.overwrite) {
                this.buffer[this.tail] = item;
                this.head = (this.head + 1) % this.capacity;
                this.tail = (this.tail + 1) % this.capacity;
                this.notEmpty.signal();
            } else {
                this.buffer[this.tail] = item;
                this.tail = (this.tail + 1) % this.capacity;
                ++this.count;
                this.notEmpty.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T take() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            T t = this.dequeue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                if (nanos <= 0L) {
                    T t = null;
                    return t;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            T t = this.dequeue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T poll() {
        this.lock.lock();
        try {
            if (this.count == 0) {
                T t = null;
                return t;
            }
            T t = this.dequeue();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private T dequeue() {
        T item = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = (this.head + 1) % this.capacity;
        --this.count;
        this.notFull.signal();
        return item;
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.count == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isFull() {
        this.lock.lock();
        try {
            boolean bl = this.count == this.capacity;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.count = 0;
            this.tail = 0;
            this.head = 0;
            for (int i = 0; i < this.capacity; ++i) {
                this.buffer[i] = null;
            }
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

