/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.segmentid.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.redisson.api.RAtomicLong;
import uno.xifan.id.generator.distributed.segmentid.IdSegment;
import uno.xifan.id.util.IdGeneratorExecutors;

public class IdSegmentChain {
    @Generated
    private static final Logger log = LogManager.getLogger(IdSegmentChain.class);
    private final RAtomicLong globalMaxId;
    private final AtomicLong step = new AtomicLong(1000L);
    private final LongAdder count = new LongAdder();
    private volatile IdSegment current = new IdSegment();
    private volatile IdSegment next = new IdSegment();

    public IdSegmentChain(RAtomicLong globalMaxId) {
        this.globalMaxId = globalMaxId;
        IdGeneratorExecutors.getScheduledExecutorService().scheduleWithFixedDelay(this::calcStep, 1L, 1L, TimeUnit.SECONDS);
        this.fetch(this.current);
        this.fetch(this.next);
    }

    public void swap() {
        IdSegment temp = this.current;
        this.current = this.next;
        this.next = temp;
    }

    public long nextId() {
        while (true) {
            if (this.current.isOverflow() && this.next.isOverflow()) {
                this.fetch(this.current);
                IdGeneratorExecutors.getExecutorService().submit(() -> this.fetch(this.next));
                break;
            }
            if (!this.current.isOverflow()) break;
            this.swap();
            IdGeneratorExecutors.getExecutorService().submit(() -> this.fetch(this.next));
        }
        this.count.increment();
        return this.current.next();
    }

    public void fetch(IdSegment idSegment) {
        long s = this.step.get();
        long nextMaxId = this.globalMaxId.getAndAdd(s);
        idSegment.setStart(nextMaxId);
        idSegment.setEnd(nextMaxId + s);
        idSegment.getCurrent().set(nextMaxId);
    }

    private void calcStep() {
        long s = this.step.get();
        long c = this.count.sumThenReset();
        if (c >= s) {
            this.step.set(c * 2L);
        } else if (c > 0L) {
            this.step.set(c);
        } else {
            this.step.set(1L);
        }
        log.info("\u8fc7\u53bb\u4e00\u79d2\u751f\u6210\uff1a{}\u4e2aID\uff0c\u8c03\u6574\u6b65\u957f\u4e3a\uff1a{}", (Object)c, (Object)s);
    }
}

