/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.snowflake;

import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributor.MachineIdDistributor;

@Component
public class SnowflakeIdGenerator
implements IdGenerator {
    private final MachineIdDistributor machineIdDistributor;
    private final long epoch;
    private final int timestampBits;
    private final int machineIdBits;
    private final int sequenceBits;
    private long lastTimestamp = -1L;
    private long sequence;

    public SnowflakeIdGenerator(RedissonClient redissonClient, @Value(value="${id.generator.snowflake.epoch:1645557742000}") long epoch, @Value(value="${id.generator.snowflake.timestamp:41}") int timestampBits, @Value(value="${id.generator.snowflake.machine:10}") int machineIdBits, @Value(value="${id.generator.snowflake.sequence:12}") int sequenceBits) {
        this.epoch = epoch;
        this.timestampBits = timestampBits;
        this.machineIdBits = machineIdBits;
        this.sequenceBits = sequenceBits;
        this.machineIdDistributor = new MachineIdDistributor(redissonClient, IdType.Snowflake.getName(), machineIdBits);
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    public synchronized Long generate() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException("\u65f6\u949f\u56de\u62e8\uff0c\u62d2\u7edd\u751f\u6210ID");
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & (-1L << this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL);
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.epoch << this.machineIdBits + this.sequenceBits | this.machineIdDistributor.get() << this.sequenceBits | this.sequence;
    }

    public IdType idType() {
        return IdType.Snowflake;
    }
}

