/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributed.ttsid.TtsId;
import uno.xifan.id.generator.distributed.ttsid.TtsIdGeneratorConfig;

@Component
public class TtsIdGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdThreadLocalHolder> threadLocalHolder;

    public TtsIdGenerator(RedissonClient redisson, TtsIdGeneratorConfig config) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdGenerator:%s:NextThreadId".formatted(config.getNamespace()));
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdThreadLocalHolder(Math.abs(threadId.getAndIncrement() % 1024L)));
    }

    public TtsId generate() {
        TtsIdThreadLocalHolder holder = this.threadLocalHolder.get();
        return holder.next();
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdThreadLocalHolder {
        private final long threadId;
        private long sequence = 0L;
        private long lastTimestamp = TtsId.currentTimestamp();

        private TtsIdThreadLocalHolder(long threadId) {
            this.threadId = threadId;
        }

        private TtsId next() {
            long timestamp = TtsId.currentTimestamp();
            if (timestamp < this.lastTimestamp) {
                timestamp = this.waitNextMilli(this.lastTimestamp);
            } else if (timestamp == this.lastTimestamp) {
                ++this.sequence;
                if (this.sequence >= 4096L) {
                    timestamp = this.waitNextMilli(this.lastTimestamp);
                    this.sequence = 0L;
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return new TtsId(timestamp, this.threadId, this.sequence);
        }

        private long waitNextMilli(long lastTimestamp) {
            long timestamp = TtsId.currentTimestamp();
            while (timestamp <= lastTimestamp) {
                timestamp = TtsId.currentTimestamp();
            }
            return timestamp;
        }
    }
}

