/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributed.ttsid.TtsIdPlus;

@Component
public class TtsIdPlusGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdPlusThreadLocalHolder> threadLocalHolder;
    private final ExecutorService executorService;

    public TtsIdPlusGenerator(RedissonClient redisson) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdPlusGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdPlusThreadLocalHolder((int)threadId.getAndIncrement()));
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
    }

    public TtsIdPlus generate() {
        try {
            return this.executorService.submit(() -> {
                TtsIdPlusThreadLocalHolder holder = this.threadLocalHolder.get();
                short s = holder.sequence;
                holder.sequence = (short)(s + 1);
                return new TtsIdPlus(TtsIdPlus.currentTimestamp(), holder.threadId, s);
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdPlusThreadLocalHolder {
        private final int threadId;
        private short sequence;

        private TtsIdPlusThreadLocalHolder(int threadId) {
            this.threadId = threadId;
        }
    }
}

