/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.distributed.ttsid;

import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.base.IdType;
import uno.xifan.id.generator.distributed.ttsid.TtsIdPro;

@Component
public class TtsIdProGenerator
implements IdGenerator {
    private final ThreadLocal<TtsIdProThreadLocalHolder> threadLocalHolder;

    public TtsIdProGenerator(RedissonClient redisson) {
        RAtomicLong threadId = redisson.getAtomicLong("IdGenerator:TtsIdProGenerator:threadId");
        this.threadLocalHolder = ThreadLocal.withInitial(() -> new TtsIdProThreadLocalHolder((int)threadId.getAndIncrement()));
    }

    public TtsIdPro generate() {
        TtsIdProThreadLocalHolder holder = this.threadLocalHolder.get();
        short s = holder.sequence;
        holder.sequence = (short)(s + 1);
        return new TtsIdPro(TtsIdPro.currentTimestamp(), holder.threadId, s);
    }

    public IdType idType() {
        return IdType.TtsId;
    }

    private static class TtsIdProThreadLocalHolder {
        private final int threadId;
        private short sequence;

        private TtsIdProThreadLocalHolder(int threadId) {
            this.threadId = threadId;
        }
    }
}

