/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.util;

import java.util.Random;

public class CrockfordBase32Encoder {
    private static final char[] CROCKFORD_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] LOOKUP_TABLE = new char[32];

    public static String encode80Bit(byte[] input) {
        if (input.length != 10) {
            throw new IllegalArgumentException("\u8f93\u5165\u5fc5\u987b\u662f10\u5b57\u8282(80\u4f4d)");
        }
        char[] output = new char[16];
        int buffer = 0;
        int bufferPos = 40;
        for (byte b : input) {
            int byteValue = b & 0xFF;
            buffer |= byteValue << bufferPos;
            bufferPos -= 8;
        }
        for (int i = 0; i < 16; ++i) {
            int index = buffer >>> 35 - i * 5 & 0x1F;
            output[i] = LOOKUP_TABLE[index];
        }
        return new String(output);
    }

    public static void main(String[] args) {
        byte[] testData = new byte[10];
        new Random().nextBytes(testData);
        String encoded = CrockfordBase32Encoder.encode80Bit(testData);
        System.out.println("Encoded: " + encoded);
        System.out.println("Length: " + encoded.length());
    }

    static {
        System.arraycopy(CROCKFORD_CHARS, 0, LOOKUP_TABLE, 0, 32);
    }
}

