/*
 * Decompiled with CFR 0.152.
 */
package uno.xifan.id.generator.web.task;

import jakarta.annotation.Resource;
import java.util.ServiceLoader;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import uno.xifan.id.base.IdGenerator;
import uno.xifan.id.generator.web.entity.IdGeneratorEntity;
import uno.xifan.id.generator.web.service.IdGeneratorService;

@Component
public class IdGeneratorTask {
    @Resource
    IdGeneratorService idGeneratorService;
    ServiceLoader<IdGenerator> loader = ServiceLoader.load(IdGenerator.class);

    @Scheduled(cron="* * * * * ?")
    public void generate() {
        for (IdGenerator generator : this.loader) {
            Object id = generator.generate();
            IdGeneratorEntity idGeneratorEntity = new IdGeneratorEntity();
            idGeneratorEntity.setId(id);
            idGeneratorEntity.setIdType(generator.idType().getName());
            this.idGeneratorService.save((Object)idGeneratorEntity);
        }
    }
}

