/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.format.PatternFormatter;
import org.apache.log.util.StackIntrospector;

public class ExtendedPatternFormatter
extends PatternFormatter {
    private static final int TYPE_METHOD = 9;
    private static final int TYPE_THREAD = 10;
    private static final String TYPE_METHOD_STR = "method";
    private static final String TYPE_THREAD_STR = "thread";
    static /* synthetic */ Class class$org$apache$log$Logger;

    public ExtendedPatternFormatter(String format) {
        super(format);
    }

    protected int getTypeIdFor(String type) {
        if (type.equalsIgnoreCase(TYPE_METHOD_STR)) {
            return 9;
        }
        if (type.equalsIgnoreCase(TYPE_THREAD_STR)) {
            return 10;
        }
        return super.getTypeIdFor(type);
    }

    protected String formatPatternRun(LogEvent event, PatternFormatter.PatternRun run) {
        switch (run.m_type) {
            case 9: {
                return this.getMethod(event, run.m_format);
            }
            case 10: {
                return this.getThread(event, run.m_format);
            }
        }
        return super.formatPatternRun(event, run);
    }

    private String getMethod(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (null != map && null != (object = map.get(TYPE_METHOD_STR))) {
            return object.toString();
        }
        String result = StackIntrospector.getCallerMethod(class$org$apache$log$Logger == null ? (class$org$apache$log$Logger = ExtendedPatternFormatter.class$("org.apache.log.Logger")) : class$org$apache$log$Logger);
        if (null == result) {
            return "UnknownMethod";
        }
        return result;
    }

    private String getThread(LogEvent event, String format) {
        Object object;
        ContextMap map = event.getContextMap();
        if (null != map && null != (object = map.get(TYPE_THREAD_STR))) {
            return object.toString();
        }
        return Thread.currentThread().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

