/**
Copyright (C) 2025 Digital Venture Consultants (info@dvc.ventures)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package ventures.dvc.karbon.provider

import ventures.dvc.karbon.location.ForecastLocation

public fun interface ValidateKeyProvider {
    public suspend operator fun invoke(request: ValidateKeyRequest): ValidateKeyResponse
}

public interface ValidateKeyRequest {
    public val key: ForecastKey
}

public fun ValidateKeyRequest(key: ForecastKey): ValidateKeyRequest =
    CoreValidateKeyRequest(key = key)

public fun ValidateKeyRequest(location: ForecastLocation, hash: ForecastHash = ForecastHash.None): ValidateKeyRequest =
    CoreValidateKeyRequest(
        key = ForecastKey(location, hash)
    )


public sealed interface ValidateKeyResponse {
    public val location: ForecastLocation
    public val hash: ForecastHash

    public data class None(override val location: ForecastLocation) : ValidateKeyResponse {
        override val hash: ForecastHash = ForecastHash.None
    }

    public data class Valid(override val location: ForecastLocation, override val hash: ForecastHash) :
        ValidateKeyResponse

    public data class Modified(override val location: ForecastLocation, override val hash: ForecastHash) :
        ValidateKeyResponse
}


private data class CoreValidateKeyRequest(
    override val key: ForecastKey,
) : ValidateKeyRequest